<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Inside\Host\Migrations\CreateContentTypes;

class CreateCoursesTable extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('inside_courses')) {
            return;
        }

        Schema::create('inside_courses', function (Blueprint $table) {
            $table->increments('id');
            $table->string('title');
            $table->uuid('model_uuid');
            $table->char('langcode', 2);
            $table->boolean('status');
            $table->integer('total_steps');
            $table->timestamps();

            $table->foreign('model_uuid')
                ->references('uuid')
                ->on(type_to_table('courses'))
                ->onDelete('cascade');

            $table->index('model_uuid');
            $table->index('langcode');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('inside_courses');
    }
}
