<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'listing_courses_categories',
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => false,
        'aliasable' => true,
        'permissible' => true,
        'categorizable' => true,
        'listing_type' => 'taxo',
        'title' => [
            'fr' => 'Listing de catégorie de formation',
            'en' => 'Training category listing',
            'es' => 'Lista de categorías de formación',
            'de' => 'Kategorie-Übersicht für Schulungen',
            'pt' => 'Lista de categorias de treinamento',
            'nl' => 'Training categorie lijst',
        ],
    ],
    'fields' => [
        [
            'name' => 'chapo',
            'searchable' => true,
            'translatable' => true,
            'search_result_field' => true,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Introduction',
                'en' => 'Introduction',
                'es' => 'Introducción',
                'nl' => 'Inleiding',
                'de' => 'Einführung',
                'pt' => 'Introdução',
            ],
            'description' => [
                'fr' => 'L\'introduction remonte sur les pages de listing d\'actualité et n\'est pas dupliquée dans votre contenu',
                'en' => 'The introduction goes up on the news listing pages and is not duplicated in your content',
                'es' => 'La introducción sube en las páginas de listado de noticias y no se duplica en su contenido',
                'nl' => 'De inleiding komt op de nieuwslijstpagina\'s en wordt niet gedupliceerd in uw inhoud',
                'de' => 'Die Einführung wird auf den Nachrichtenlisten-Seiten nach oben verschoben und nicht in Ihrem Inhalt dupliziert',
                'pt' => 'A introdução sobe nas páginas de listagem de notícias e não é duplicada em seu conteúdo',
            ],
            'widget' => [
                'type' => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [
                    'rows' => 5,
                    'placeholder' => '',
                ],
                'weight' => 1,
            ],
            'type' => BridgeContentType::TEXTAREA_FIELD,
            'settings' => [
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'banner',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'search_filter' => false,
            'required' => false,
            'weight' => 2,
            'title' => [
                'fr' => 'Bannière',
                'en' => 'Banner',
                'es' => 'Banner',
                'pt' => 'Banner',
                'de' => 'Banner',
                'nl' => 'Banner',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => 2,
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
    ],
];
