<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'courses_quizzes',
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => false,
        'aliasable' => false,
        'permissible' => false,
        'categorizable' => false,
        'listing_type' => 'content',
        'title' => [
            'fr' => 'Quiz de formation',
            'en' => 'Training quiz',
            'es' => 'Cuestionario de formación',
            'de' => 'Schulungsquiz',
            'pt' => 'Questionário de treinamento',
            'nl' => 'Training quiz',
        ],
    ],
    'fields' => [
        [
            'name' => 'courses_chapters',
            'classifiable' => 'courses',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => true,
            'searchable_filter' => true,
            'required' => true,
            'weight' => 0,
            'title' => [
                'fr' => 'Chapitre de formation',
                'en' => 'Training chapter',
                'es' => 'Capítulo de formación',
                'de' => 'Schulungskapitel',
                'pt' => 'Capítulo de treinamento',
                'nl' => 'Trainingshoofdstuk',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 0,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['courses_chapters'],
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'weight',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Ordre d\'affichage',
                'en' => 'Order of appearance',
                'es' => 'Orden de aparición',
                'de' => 'Reihenfolge des Erscheinens',
                'pt' => 'Ordem de aparência',
                'nl' => 'Volgorde van verschijning',
            ],
            'description' => [
                'fr' => 'Le nombre de plus bas remontera tout en haut',
                'en' => 'The lower number will go up at the top',
                'es' => 'El número más bajo subirá en la parte superior',
                'de' => 'Die niedrigere Nummer wird nach oben gehen',
                'pt' => 'O número menor subirá no topo',
                'nl' => 'Het lagere nummer komt bovenaan te staan',
            ],
            'widget' => [
                'type' => BridgeContentType::NUMBER_WIDGET,
                'settings' => [],
                'weight' => 1,
            ],
            'type' => BridgeContentType::INTEGER_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'description',
            'searchable' => true,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 2,
            'title' => [
                'fr' => 'Description',
                'en' => 'Description',
                'es' => 'Descripción',
                'de' => 'Beschreibung',
                'pt' => 'Descrição',
                'nl' => 'Beschrijving',
            ],
            'widget' => [
                'type' => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 2,
            ],
            'type' => BridgeContentType::TEXTAREA_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'min_valid_values',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 3,
            'title' => [
                'fr' => 'Nombre de réponses valides obligatoires',
                'en' => 'Number of compulsory valid responses',
                'es' => 'Número de respuestas válidas obligatorias',
                'de' => 'Anzahl der obligatorischen gültigen Antworten',
                'pt' => 'Número de respostas válidas obrigatórias',
                'nl' => 'Aantal verplichte geldige antwoorden',
            ],
            'description' => [
                'fr' => 'Il ne pourra pas valider cette étape',
                'en' => 'He will not be able to validate this step',
                'es' => 'No podrá validar este paso',
                'nl' => 'Hij zal deze stap niet kunnen valideren',
                'pt' => 'Ele não poderá validar esta etapa',
                'de' => 'Er wird diesen Schritt nicht validieren können',
            ],
            'widget' => [
                'type' => BridgeContentType::NUMBER_WIDGET,
                'settings' => [],
                'weight' => 3,
            ],
            'type' => BridgeContentType::INTEGER_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'content',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => true,
            'weight' => 4,
            'title' => [
                'fr' => 'Questions',
                'en' => 'Questions',
                'es' => 'Preguntas',
                'de' => 'Fragen',
                'pt' => 'Perguntas',
                'nl' => 'Vragen',
            ],
            'widget' => [
                'type' => BridgeContentType::SECTION_WIDGET,
                'settings' => [
                    'title' => 'Paragraphe',
                    'title_plural' => 'Paragraphes',
                    'edit_mode' => 'open',
                    'add_mode' => 'dropdown',
                    'form_display_mode' => 'default',
                    'default_paragraph_type' => '',
                ],
                'weight' => 4,
            ],
            'type' => BridgeContentType::SECTION_FIELD,
            'settings' => [
                'target_type' => [
                    'course_question',
                ],
                'cardinality' => -1,
            ],
        ],
        [
            'name' => 'success_text',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 5,
            'title' => [
                'fr' => 'Texte en cas de succès',
                'en' => 'Text in case of success',
                'es' => 'Texto en caso de éxito',
                'de' => 'Text im Erfolgsfall',
                'pt' => 'Texto em caso de sucesso',
                'nl' => 'Tekst in geval van succes',
            ],
            'description' => [
                'fr' => 'Ce texte s\'affichera si l\'utilisateur a atteint le nombre de bonnes réponses requis.',
                'en' => 'This text will appear if the user has reached the required number of correct responses.',
                'es' => 'Este texto aparecerá si el usuario ha alcanzado el número requerido de respuestas correctas.',
                'de' => 'Dieser Text wird angezeigt, wenn der Benutzer die erforderliche Anzahl von korrekten Antworten erreicht hat.',
                'pt' => 'Este texto aparecerá se o usuário tiver atingido o número necessário de respostas corretas.',
                'nl' => 'Deze tekst verschijnt als de gebruiker het vereiste aantal juiste antwoorden heeft behaald.',
            ],
            'widget' => [
                'type' => BridgeContentType::WYSIWYG_WIDGET,
                'settings' => [],
                'weight' => 5,
            ],
            'type' => BridgeContentType::WYSIWYG_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'failure_text',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 6,
            'title' => [
                'fr' => 'Texte en cas d\'échec',
                'en' => 'Text in case of failure',
                'es' => 'Texto en caso de fallo',
                'de' => 'Text im Fehlerfall',
                'pt' => 'Texto em caso de falha',
                'nl' => 'Tekst in geval van mislukking',
            ],
            'description' => [
                'fr' => 'Ce texte s\'affichera si l\'utilisateur n\'a pas atteint le nombre de bonnes réponses requis.',
                'en' => 'This text will be displayed if the user has not reached the required number of correct responses.',
                'es' => 'Este texto se mostrará si el usuario no ha alcanzado el número requerido de respuestas correctas.',
                'de' => 'Dieser Text wird angezeigt, wenn der Benutzer die erforderliche Anzahl von korrekten Antworten nicht erreicht hat.',
                'pt' => 'Este texto será exibido se o usuário não tiver atingido o número necessário de respostas corretas.',
                'nl' => 'Deze tekst wordt weergegeven als de gebruiker het vereiste aantal juiste antwoorden niet heeft behaald.',
            ],
            'widget' => [
                'type' => BridgeContentType::WYSIWYG_WIDGET,
                'settings' => [],
                'weight' => 6,
            ],
            'type' => BridgeContentType::WYSIWYG_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ],
    ],
];
