<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'courses_lessons',
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => false,
        'aliasable' => false,
        'permissible' => false,
        'categorizable' => false,
        'listing_type' => 'content',
        'title' => [
            'fr' => 'Leçon de formation',
            'en' => 'Training lesson',
            'es' => 'Lección de formación',
            'de' => 'Schulungslektion',
            'pt' => 'Lições de treinamento',
            'nl' => 'Trainingsles',
        ],
    ],
    'fields' => [
        [
            'name' => 'courses_chapters',
            'classifiable' => 'courses',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => true,
            'searchable_filter' => true,
            'required' => true,
            'weight' => 0,
            'title' => [
                'fr' => 'Chapitre de formation',
                'en' => 'Training chapter',
                'es' => 'Capítulo de formación',
                'de' => 'Schulungskapitel',
                'pt' => 'Capítulo de formação',
                'nl' => 'Trainingshoofdstuk',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 0,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['courses_chapters'],
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'weight',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Ordre d\'affichage',
                'en' => 'Order of appearance',
                'es' => 'Orden de aparición',
                'de' => 'Reihenfolge des Erscheinens',
                'pt' => 'Ordem de aparência',
                'nl' => 'Volgorde van verschijning',
            ],
            'description' => [
                'fr' => 'Le nombre de plus bas remontera tout en haut',
                'en' => 'The lower number will go up at the top',
                'es' => 'El número más bajo subirá en la parte superior',
                'de' => 'Die niedrigere Nummer wird nach oben gehen',
                'pt' => 'O número menor subirá no topo',
                'nl' => 'Het lagere nummer komt bovenaan te staan',
            ],
            'widget' => [
                'type' => BridgeContentType::NUMBER_WIDGET,
                'settings' => [],
                'weight' => 1,
            ],
            'type' => BridgeContentType::INTEGER_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'content',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 2,
            'title' => [
                'fr' => 'Contenu',
                'en' => 'Content',
                'es' => 'Contenido',
                'de' => 'Inhalt',
                'pt' => 'Conteúdo',
                'nl' => 'Inhoud',
            ],
            'widget' => [
                'type' => BridgeContentType::SECTION_WIDGET,
                'settings' => [
                    'title' => 'Paragraphe',
                    'title_plural' => 'Paragraphes',
                    'edit_mode' => 'open',
                    'add_mode' => 'dropdown',
                    'form_display_mode' => 'default',
                    'default_paragraph_type' => '',
                ],
                'weight' => 2,
            ],
            'type' => BridgeContentType::SECTION_FIELD,
            'settings' => [
                'target_type' => [
                    'text',
                    'text_two_columns',
                    'text_with_image',
                    'separator',
                    'file',
                    'slider',
                    'image',
                    'video',
                    'map',
                    'accordion',
                    'call_to_action',
                    'button',
                    'html',
                    'tweet',
                    'fetched_contents',
                ],
                'cardinality' => -1,
            ],
        ],
    ],
];
