<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'courses_categories',
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => false,
        'aliasable' => true,
        'permissible' => true,
        'categorizable' => true,
        'listing_type' => 'taxo',
        'title' => [
            'fr' => 'Catégorie de formation',
            'en' => 'Training category',
            'es' => 'Categoría de formación',
            'de' => 'Schulungskategorie',
            'pt' => 'Categoria de formação',
            'nl' => 'Trainingscategorie',
        ],
    ],
    'fields' => [
        [
            'name' => 'banner',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 0,
            'title' => [
                'fr' => 'Bannière',
                'en' => 'Banner',
                'es' => 'Banner',
                'de' => 'Banner',
                'pt' => 'Banner',
                'nl' => 'Banner',
            ],
            'description' => [
                'fr' => 'Remontera en haut de la page de la catégorie de formation',
                'en' => 'Will go up at the top of the training category page',
                'es' => 'Subirá en la parte superior de la página de categoría de formación',
                'de' => 'Wird oben auf der Schulungskategorienseite angezeigt',
                'pt' => 'Subirá no topo da página de categoria de formação',
                'nl' => 'Zal bovenaan de trainingscategoriepagina verschijnen',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => 0,
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'introduction',
            'searchable' => true,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Introduction',
                'en' => 'Introduction',
                'es' => 'Introducción',
                'de' => 'Einführung',
                'pt' => 'Introdução',
                'nl' => 'Inleiding',
            ],
            'description' => [
                'fr' => 'Ce texte sera affiché en haut de la page de la catégorie de formation',
                'en' => 'This text will be displayed at the top of the training category page',
                'es' => 'Este texto se mostrará en la parte superior de la página de categoría de formación',
                'de' => 'Dieser Text wird oben auf der Schulungskategorienseite angezeigt',
                'pt' => 'Este texto será exibido no topo da página de categoria de formação',
                'nl' => 'Deze tekst wordt bovenaan de trainingscategoriepagina weergegeven',
            ],
            'widget' => [
                'type' => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 1,
            ],
            'type' => BridgeContentType::TEXTAREA_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'image',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 2,
            'title' => [
                'fr' => 'Image',
                'en' => 'Picture',
                'es' => 'Imagen',
                'de' => 'Bild',
                'pt' => 'Imagem',
                'nl' => 'Afbeelding',
            ],
            'description' => [
                'fr' => 'Remontera sur le listing des catégories de formation',
                'en' => 'Will go back on the list of training categories',
                'es' => 'Volverá a la lista de categorías de formación',
                'de' => 'Wird wieder auf der Liste der Schulungskategorien angezeigt',
                'pt' => 'Voltará à lista de categorias de formação',
                'nl' => 'Keert terug naar de lijst met trainingscategorieën',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => 2,
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'weight',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 3,
            'title' => [
                'fr' => 'Ordre d\'affichage',
                'en' => 'Order of appearance',
                'es' => 'Orden de aparición',
                'de' => 'Reihenfolge des Erscheinens',
                'pt' => 'Ordem de aparência',
                'nl' => 'Volgorde van verschijning',
            ],
            'description' => [
                'fr' => 'Le nombre de plus bas remontera tout en haut',
                'en' => 'The lower number will go up at the top',
                'es' => 'El número más bajo subirá en la parte superior',
                'de' => 'Die niedrigere Nummer wird nach oben gehen',
                'pt' => 'O número menor subirá no topo',
                'nl' => 'Het lagere nummer komt bovenaan te staan',
            ],
            'widget' => [
                'type' => BridgeContentType::NUMBER_WIDGET,
                'settings' => [],
                'weight' => 3,
            ],
            'type' => BridgeContentType::INTEGER_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ],
    ],
];
