<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'courses',
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => true,
        'aliasable' => true,
        'permissible' => true,
        'categorizable' => true,
        'listing_type' => 'content',
        'title' => [
            'fr' => 'Formation',
            'en' => 'Training',
            'es' => 'Formación',
            'de' => 'Training',
            'pt' => 'Formação',
            'nl' => 'Training',
        ],
    ],
    'fields' => [
        [
            'name' => 'image',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 0,
            'title' => [
                'fr' => 'Image',
                'en' => 'Picture',
                'es' => 'Imagen',
                'de' => 'Bild',
                'pt' => 'Imagem',
                'nl' => 'Afbeelding',
            ],
            'description' => [
                'fr' => 'Remontera sur le listing des formations',
                'en' => 'Will go back on the training listing',
                'es' => 'Volverá a la lista de formación',
                'de' => 'Wird zur Trainingsliste zurückkehren',
                'pt' => 'Voltará à lista de formação',
                'nl' => 'Komt terug op de traininglijst',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => 0,
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'duration',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Durée',
                'en' => 'Duration',
                'es' => 'Duración',
                'de' => 'Dauer',
                'pt' => 'Duração',
                'nl' => 'Duur',
            ],
            'description' => [
                'fr' => 'La durée est renseignée à titre indicatif et remontera sur la page de listing des formations',
                'en' => 'The duration is informed as an indication and will date the training list page',
                'es' => 'La duración se informa como indicación y fechará la página de lista de formación',
                'de' => 'Die Dauer wird als Hinweis angegeben und datiert die Trainingsliste',
                'pt' => 'A duração é informada como indicação e datará a página de lista de formação',
                'nl' => 'De duur wordt aangegeven als indicatie en zal de trainingslijst dateren',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 1,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'courses_categories',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => true,
            'searchable_filter' => true,
            'required' => true,
            'weight' => 2,
            'title' => [
                'fr' => 'Catégorie de formation',
                'en' => 'Training category',
                'es' => 'Categoría de formación',
                'de' => 'Trainingskategorie',
                'pt' => 'Categoria de formação',
                'nl' => 'Training categorie',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 2,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['courses_categories'],
                'cardinality' => -1,
            ],
        ],
        [
            'name' => 'weight',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 3,
            'title' => [
                'fr' => 'Ordre d\'affichage',
                'en' => 'Order of appearance',
                'es' => 'Orden de aparición',
                'de' => 'Reihenfolge des Erscheinens',
                'pt' => 'Ordem de aparência',
                'nl' => 'Volgorde van verschijning',
            ],
            'description' => [
                'fr' => 'Le nombre de plus bas remontera tout en haut',
                'en' => 'The lower number will go up at the top',
                'es' => 'El número más bajo subirá en la parte superior',
                'de' => 'Die niedrigere Nummer wird nach oben gehen',
                'pt' => 'O número menor subirá no topo',
                'nl' => 'Het lagere nummer komt bovenaan te staan',
            ],
            'widget' => [
                'type' => BridgeContentType::NUMBER_WIDGET,
                'settings' => [],
                'weight' => 3,
            ],
            'type' => BridgeContentType::INTEGER_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'end_title',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 4,
            'title' => [
                'fr' => 'Titre de la page de fin de formation',
                'en' => 'End of Course Page Title',
                'es' => 'Título de la página de finalización del curso',
                'de' => 'Titel der Abschlussseite des Trainings',
                'pt' => 'Título da página de finalização do curso',
                'nl' => 'Titel van de eindpagina van de opleiding',
            ],
            'widget' => [
                'type' => BridgeContentType::TEXT_WIDGET,
                'settings' => [],
                'weight' => 4,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'end_content',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 5,
            'title' => [
                'fr' => 'Contenu de la page de fin de formation',
                'en' => 'End of Course Page Content',
                'es' => 'Contenido de la página de finalización del curso',
                'de' => 'Inhalt der Abschlussseite des Trainings',
                'pt' => 'Conteúdo da página de finalização do curso',
                'nl' => 'Inhoud van de eindpagina van de opleiding',
            ],
            'widget' => [
                'type' => BridgeContentType::WYSIWYG_WIDGET,
                'settings' => [],
                'weight' => 5,
            ],
            'type' => BridgeContentType::WYSIWYG_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'published',
            'required' => false,
            'weight' => 6,
            'default' => false,
            'title' => [
                'fr' => 'Visible pour les utilisateurs',
                'en' => 'Visible to users',
                'es' => 'Visible para los usuarios',
                'nl' => 'Zichtbaar voor gebruikers',
                'pt' => 'Visível para os usuários',
                'de' => 'Für Benutzer sichtbar',
            ],
            'description' => [],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [],
                'weight' => 6,
                'hidden' => true,
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [],
        ],
    ],
];
