<?php

declare(strict_types=1);

use Illuminate\Console\Scheduling\Schedule;
use Inside\Course\Facades\CourseReminder;

return [
    'schedule' => [
        'compute_courses_stats' => fn (Schedule $schedule) => $schedule->command('inside:courses:stats:compute')->dailyAt('04:00'),
        'courses_reminder' => function (Schedule $schedule) {
            CourseReminder::scheduleReminderCommand($schedule);
        },
    ]
];
