<?php

declare(strict_types=1);

namespace Inside\Course\Observers;

use Inside\Course\Contracts\CourseProgression;
use Inside\Course\Models\Step;

final class StepObserver
{
    public function __construct(
        private CourseProgression $courseProgression
    ) {
    }

    public function saved(Step $step): void
    {
        $this->courseProgression->updateCourseTotalSteps($step->chapter->course);
    }

    public function deleted(Step $step): void
    {
        $this->courseProgression->updateCourseTotalSteps($step->chapter->course);
    }
}
