<?php

declare(strict_types=1);

namespace Inside\Course\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Inside\Authentication\Models\User;
use Inside\Database\Eloquent\Builder;
use Inside\Database\Eloquent\WithEnhancedBuilder;

/**
 * @property int $id
 * @property int $validated_steps
 * @property int $created_at
 * @property int $updated_at
 * @property float $ratio
 * @property User $user
 * @property Course $course
 *
 * @method static static create(array $attributes = [])
 * @method static static firstOrFail(array $attributes = [])
 * @method static static updateOrCreate(array $attributes, array $values = [])
 * @method static static|null firstWhere($column, $operator = null, $value = null, $boolean = 'and')
 * @method static Builder query()
 * @method static Builder where($column, $operator = null, $value = null, $boolean = 'and')
 * @method static Builder whereIn($column, $values, $boolean = 'and', $not = false)
 */
class UserProgression extends Model
{
    use WithEnhancedBuilder;

    /**
     * @var string
     */
    protected $table = 'inside_courses_users_progressions';

    /**
     * @var string[]
     */
    protected $fillable = [
        'validated_steps',
        'ratio',
        'course_id',
        'user_uuid',
        'created_at',
        'updated_at',
    ];

    /**
     * @var array
     */
    protected $casts = [
        'created_at' => 'timestamp',
        'updated_at' => 'timestamp',
    ];

    public function course(): BelongsTo
    {
        return $this->belongsTo(Course::class);
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function scopeWithoutMaintenance(Builder $query): Builder
    {
        return $query->whereHas(
            'user.information',
            fn (Builder $query) => $query
                ->where('is_maintenance', false)
                ->where('status', true)
        );
    }
}
