<?php

namespace Inside\Course\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Inside\Database\Eloquent\WithEnhancedBuilder;
use Inside\Permission\Models\Role;
use Inside\Course\Models\Course;

class CoursesRoles extends Model
{
    use WithEnhancedBuilder;

    protected $table = 'inside_courses_roles';

    protected $primaryKey = 'id';
    public $incrementing = true;
    protected $keyType = 'int';

    public $timestamps = true;

    protected $fillable = [
        'course_id',
        'role_id',
    ];

    public function course(): BelongsTo
    {
        return $this->belongsTo(
            Course::class,
            'course_id',
            'id'
        );
    }

    public function role(): BelongsTo
    {
        return $this->belongsTo(
            Role::class,
            'role_id',
            'id'
        );
    }
}
