<?php

declare(strict_types=1);

namespace Inside\Course\Models;

use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Inside\Content\Models\Contents\Courses;
use Inside\Database\Eloquent\Builder;
use Inside\Database\Eloquent\WithEnhancedBuilder;

/**
 * @property int $id
 * @property int $course_id
 * @property int $viewed
 * @property int $not_viewed
 * @property int $finished
 * @property int $not_finished
 * @property float $average_ratio
 * @property Course $course
 * @property-read Courses $model
 *
 * @method static static create(array $attributes = [])
 * @method static static firstOrFail(array $attributes = [])
 * @method static static updateOrCreate(array $attributes, array $values = [])
 * @method static static|null firstWhere($column, $operator = null, $value = null, $boolean = 'and')
 * @method static Builder query()
 * @method static Builder where($column, $operator = null, $value = null, $boolean = 'and')
 *
 * @mixin Collection
 */
class CourseStatistics extends Model
{
    use WithEnhancedBuilder;

    /**
     * @var string
     */
    protected $table = 'inside_courses_statistics';

    /**
     * @var bool
     */
    public $timestamps = false;

    /**
     * @var string[]
     */
    protected $fillable = [
        'course_id',
        'viewed',
        'not_viewed',
        'finished',
        'not_finished',
        'average_ratio',
    ];


    public function course(): BelongsTo
    {
        return $this->belongsTo(Course::class);
    }
}
