<?php

declare(strict_types=1);

namespace Inside\Course\Listeners;

use Inside\Content\Events\ContentDeletedEvent;
use Inside\Content\Events\ContentFullyInsertedEvent;
use Inside\Content\Events\ContentFullyUpdatedEvent;
use Inside\Content\Models\Contents\Courses;
use Inside\Course\Models\Course;

final class SynchronizeCourse
{
    public function handleCourseUpdateOrCreate(ContentFullyInsertedEvent | ContentFullyUpdatedEvent $event): void
    {
        if (! $event->model instanceof Courses) {
            return;
        }

        $courseContent = $event->model;

        Course::updateOrCreate(
            ['model_uuid' => $courseContent->uuid],
            [
                'title' => $courseContent->title,
                'status' => $courseContent->status,
                'langcode' => $courseContent->langcode,
            ]
        );
    }

    public function handleCourseDeletion(ContentDeletedEvent $event): void
    {
        if (! $event->model instanceof Courses) {
            return;
        }

        Course::firstWhere('model_uuid', $event->model->uuid)?->delete();
    }

    public function subscribe(): array
    {
        return [
            ContentFullyInsertedEvent::class => 'handleCourseUpdateOrCreate',
            ContentFullyUpdatedEvent::class => 'handleCourseUpdateOrCreate',
            ContentDeletedEvent::class => 'handleCourseDeletion',
        ];
    }
}
