<?php

namespace Inside\Course\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Support\Collection;
use Inside\Authentication\Events\FirstConnection;
use Inside\Course\Enums\NotificationChannel;
use Inside\Notify\Listeners\BaseNotificationListener;
use Inside\Notify\Models\NotificationSubscriber;
use Inside\Notify\Models\NotificationType;
use Inside\Settings\Models\Setting;

class HandleFirstConnection extends BaseNotificationListener implements ShouldQueue
{
    public function handle(FirstConnection $event): void
    {
        $isOnboardingNotificationEnabled = Setting::where(['group' => 'courses', 'key' => 'onboarding_email_enabled'])->first()?->value;
        $onboardingCourseUuid = Setting::where(['group' => 'courses', 'key' => 'onboarding_course'])->first()?->value;

        if (! $isOnboardingNotificationEnabled || ! $onboardingCourseUuid) {
            return;
        }

        /**
         * @var Collection<NotificationType>
         */
        $notificationTypes = NotificationType::where([
            'event' => 'Inside\Authentication\Events\FirstConnection',
            'action' => 'onboarding',
        ])->get();

        $onboardingCourse = type_to_class('courses')::findOrFail($onboardingCourseUuid);

        $user = $event->user;
        $this->route = $user;
        foreach ($notificationTypes as $notificationType) {
            if ($notificationType->via === NotificationChannel::WEB) {
                NotificationSubscriber::updateOrCreate([
                    'user_uuid'            => $user->uuid,
                    'notification_type_id' => $notificationType->id,
                ]);
            }
            $this->route = $user;
            $this->notify($notificationType, $user, $onboardingCourse);
        }
    }
}
