<?php

namespace Inside\Course\Listeners;

use Inside\Settings\Events\SettingSavedEvent;
use Inside\Course\Facades\CourseReminder;
use Illuminate\Console\Scheduling\Schedule;

class CoursesSettingsSavedListener
{
    public function handle(SettingSavedEvent $event): void
    {
        $model = $event->model;
        if ($model->group !== 'courses' && ! in_array($model->key, ['reminder_email_recurrence_type', 'reminder_email_day', 'reminder_email_hour', 'reminder_email_enabled'])) {
            return;
        }

        /** @var \Illuminate\Console\Scheduling\Schedule $schedule */
        $schedule = app(Schedule::class);
        CourseReminder::scheduleReminderCommand($schedule);
    }
}
