<?php

declare(strict_types=1);

namespace Inside\Course\Listeners;

use Inside\Content\Events\ContentUpdatedEvent;
use Inside\Content\Models\Contents\Courses;
use Inside\Course\Contracts\CourseNotifications;

final class CoursesPublishedListener
{
    public function __construct(
        private CourseNotifications $courseNotifications
    ) {
    }

    public function handle(ContentUpdatedEvent $event): void
    {
        $model = $event->model;

        if (! $model instanceof Courses || ! $model->published || ! $model->isDirty('published')) {
            return;
        }

        $this->courseNotifications->sendNotifications($model);
    }
}
