<?php

declare(strict_types=1);

namespace Inside\Course\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Auth;
use Inside\Authentication\Models\User;
use Inside\Content\Models\Contents\CoursesCategories;
use Inside\Course\Contracts\CourseNotifications;

final class CoursesCategoriesController extends Controller
{
    public function subscribe(string $uuid, CourseNotifications $courseNotifications): JsonResponse
    {
        /** @var User $user */
        $user = Auth::user();

        /** @var CoursesCategories $coursesCategory */
        $coursesCategory = CoursesCategories::findOrFail($uuid);

        $courseNotifications->subscribe($coursesCategory, $user);

        return response()->json(['subscribed' => true]);
    }

    public function unsubscribe(string $uuid, CourseNotifications $courseNotifications): JsonResponse
    {
        /** @var User $user */
        $user = Auth::user();

        /** @var CoursesCategories $coursesCategory */
        $coursesCategory = CoursesCategories::findOrFail($uuid);

        $courseNotifications->unsubscribe($coursesCategory, $user);

        return response()->json(['subscribed' => false]);
    }

    public function isSubscribed(string $uuid, CourseNotifications $courseNotifications): JsonResponse
    {
        /** @var User $user */
        $user = Auth::user();

        /** @var CoursesCategories $coursesCategory */
        $coursesCategory = CoursesCategories::findOrFail($uuid);

        return response()->json(['subscribed' => $courseNotifications->isSubscribed($coursesCategory, $user)]);
    }
}
