<?php

declare(strict_types=1);

namespace Inside\Course\Exports;

use Illuminate\Support\Facades\Lang;
use Inside\Course\Contracts\CourseUsersStatistics;
use Inside\Support\Str;

final class CourseUsersStatisticsExport extends AbstractCourseStatisticsExport
{
    private ?CourseUsersStatistics $courseUsersStatistics = null;

    private function getCourseUsersStatistics(): CourseUsersStatistics
    {
        return $this->courseUsersStatistics ??= app(CourseUsersStatistics::class);
    }

    public function __construct(
        private ?string $search = null,
        private array $filters = [],
        private ?string $langcode = 'en'
    ) {
    }

    public function query()
    {
        return $this->getCourseUsersStatistics()->getCourseUsersStatisticsQuery($this->search, $this->filters);
    }

    public function headings(): array
    {
        if ($this->langcode) {
            Lang::setLocale($this->langcode);
        }

        return [
            Lang::get('courses.statistics.export.users.cols.full_name'),
            Lang::get('courses.statistics.export.users.cols.email'),
            Lang::get('courses.statistics.export.users.cols.finished'),
            Lang::get('courses.statistics.export.users.cols.started'),
        ];
    }

    public function map($row): array
    {
        return [
            trim(Str::title($row->firstname).' '.Str::upper($row->lastname)) ?: null,
            $row->email,
            "$row->finished",
            "$row->started",
        ];
    }
}
