<?php

declare(strict_types=1);

namespace Inside\Course\Exports;

use Illuminate\Support\Facades\Lang;
use Inside\Course\Contracts\CourseStatistics;
use Inside\Database\Eloquent\Builder;
use Inside\Support\Str;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;

final class CourseDetailStatisticsExport extends AbstractCourseStatisticsExport
{
    private ?CourseStatistics $courseStatistics = null;

    private function getCourseStatistics(): CourseStatistics
    {
        return $this->courseStatistics ??= app(CourseStatistics::class);
    }

    public function __construct(
        private string $courseUuid,
        private ?string $search = null,
        private array $filters = [],
        private ?string $langcode = 'en'
    ) {
    }

    public function query(): Builder
    {
        return $this->getCourseStatistics()->getCoursesDetailStatisticsQuery($this->courseUuid, $this->search, $this->filters);
    }

    public function headings(): array
    {
        if ($this->langcode) {
            Lang::setLocale($this->langcode);
        }

        return [
            Lang::get('courses.statistics.export.course.detail.cols.full_name'),
            Lang::get('courses.statistics.export.course.detail.cols.viewed'),
            Lang::get('courses.statistics.export.course.detail.cols.started'),
            Lang::get('courses.statistics.export.course.detail.cols.finished'),
            Lang::get('courses.statistics.export.course.detail.cols.ratio'),
        ];
    }

    public function map($row): array
    {
        return [
            trim(Str::title($row->firstname).' '.Str::upper($row->lastname)) ?: null,
            $this->mapBooleanValue($row->viewed),
            $this->mapBooleanValue($row->started),
            $this->mapBooleanValue($row->finished),
            $row->ratio * 100 .'%',
        ];
    }
}
