<?php

declare(strict_types=1);

namespace Inside\Course\Exports;

use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Support\Facades\Lang;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithColumnFormatting;
use Maatwebsite\Excel\Concerns\WithCustomCsvSettings;
use Maatwebsite\Excel\Concerns\WithCustomQuerySize;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;

abstract class AbstractCourseStatisticsExport implements
    FromQuery,
    WithMapping,
    ShouldQueue,
    ShouldAutoSize,
    WithCustomCsvSettings,
    WithHeadings,
    WithCustomQuerySize,
    WithColumnFormatting
{
    use Exportable;

    public function getCsvSettings(): array
    {
        return [
            'delimiter' => ',',
            'enclosure' => '"',
            'line_ending' => PHP_EOL,
            'use_bom' => true,
            'include_separator_line' => false,
            'excel_compatibility' => true,
        ];
    }

    public function querySize(): int
    {
        return $this->query()->count();
    }

    public function columnFormats(): array
    {
        return [];
    }

    protected function mapBooleanValue(?bool $value, array $keys = []): string
    {
        return match ($value) {
            true => Lang::get($keys['true'] ?? 'courses.statistics.export.values.boolean.true'),
            default => Lang::get($keys['false'] ?? 'courses.statistics.export.values.boolean.false'),
        };
    }
}
