<?php

declare(strict_types=1);

namespace Inside\Course\Contracts;

use Illuminate\Contracts\Pagination\LengthAwarePaginator;
use Illuminate\Contracts\Pagination\Paginator;
use Illuminate\Support\Collection;
use Inside\Database\Eloquent\Builder;

interface CourseStatistics
{
    public function getCoursesStatistics(?string $search = null, array $filters = []): Paginator | Collection | LengthAwarePaginator | array;

    public function getCoursesStatisticsQuery(?string $search = null, array $filters = []): Builder;

    public function getCoursesDetailStatisticsQuery(string $courseUuid, ?string $search = null, array $filters = []): Builder;

    public function getCoursesDetailStatistics(string $courseUuid, ?string $search = null, array $filters = []): Paginator | Collection | LengthAwarePaginator | array;
}
