<?php

declare(strict_types=1);

namespace Inside\Course\Contracts;

use Inside\Authentication\Models\User;
use Inside\Course\Models\Course;
use Inside\Course\Models\UserProgression;

interface CourseProgression
{
    public function getUserCourseProgression(User $user, Course $course): array;

    public function updateCourseTotalSteps(Course $course): bool;

    public function computeUserProgression(Course $course, User $user): UserProgression;

    public function computeAllProgressions(Course $course): void;
}
