<?php

declare(strict_types=1);

namespace Inside\Course\Contracts;

use Illuminate\Support\Collection;
use Inside\Authentication\Models\User;
use Inside\Content\Models\Contents\Courses;
use Inside\Content\Models\Contents\CoursesCategories;

interface CourseNotifications
{
    public function createNotificationTypes(CoursesCategories $coursesCategory): Collection;

    public function deleteNotificationTypes(CoursesCategories $coursesCategory): void;

    public function isSubscribed(CoursesCategories $coursesCategory, User $user): bool;

    public function subscribe(CoursesCategories $coursesCategory, User $user): void;

    public function unsubscribe(CoursesCategories $coursesCategory, User $user): void;

    public function sendNotifications(Courses $course): void;
}
