<?php

declare(strict_types=1);

namespace Inside\Course\Console;

use Inside\Console\Command;
use Inside\Content\Models\Content;
use Inside\Host\Bridge\BridgeContent;

final class SynchronizeCoursesCommand extends Command
{
    /**
     * @var string
     */
    protected $signature = 'inside:courses:sync';

    /**
     * @var string
     */
    protected $description = 'Synchronisation des contenus drupal avec les tables inside_courses';

    public function handle(): void
    {
        $bridge = new BridgeContent();

        collect([
            'courses',
            'courses_chapters',
            'courses_lessons',
            'courses_quizzes',
        ])->each(function (string $contentType) use ($bridge) {
            type_to_class($contentType)::each(fn (Content $content) => $bridge->contentUpdate($content->content_type, ['uuid' => $content->uuid]));
        });
    }
}
