<?php

declare(strict_types=1);

namespace Inside\Course\Console;

use Illuminate\Database\Eloquent\Builder;
use Inside\Console\Command;
use Inside\Content\Models\Contents\Courses;
use Inside\Course\Facades\CourseReminder;

final class SendReminderEmailsCommand extends Command
{
    /**
     * @var string
     */
    protected $signature = 'inside:courses:reminder:send';

    /**
     * @var string
     */
    protected $description = 'Send reminder emails';

    public function handle(): void
    {
        $isReminderEnabled = (int) setting('courses', 'reminder_email_enabled', '0');
        if ($isReminderEnabled !== 1) {
            return;
        }

        CourseReminder::notifyUsers();
    }
}
