<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Users;
use Inside\Notify\Models\NotificationSubscriber;
use Inside\Notify\Models\NotificationType;

class CreateNotificationTypesForWeb extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        NotificationType::firstOrCreate(
            [
                'via'       => 'web',
                'default'   => true,
                'event'     => 'Inside\Authentication\Events\FirstConnection',
                'model'     => 'Inside\Content\Models\Contents\Courses',
                'action'    => 'onboarding',
                'type'      => 'global',
                'condition' => null,
                'multiple'  => false,
                'language'  => false,
                'profile'   => false,
            ],
            [
                'data' => [
                    'title' => 'notifications.courses.onboarding.title',
                    'description' => 'notifications.courses.onboarding.description',
                    'icon'        => '',
                    'text' => 'notifications.courses.onboarding.text',
                    'fields' => [
                        'title',
                        'duration',
                        'content_type',
                    ],
                ],
            ]
        );

        NotificationType::firstOrCreate(
            [
                'via'       => 'web',
                'default'   => true,
                'event'     => null,
                'model'     => 'Inside\Content\Models\Contents\Courses',
                'action'    => 'reminder',
                'type'      => 'global',
                'condition' => null,
                'multiple'  => false,
                'language'  => false,
                'profile'   => false,
            ],
            [
                'data' => [
                    'title' => 'notifications.courses.reminder.title',
                    'description' => 'notifications.courses.reminder.description',
                    'text' => 'notifications.courses.reminder.text',
                    'fields' => [],
                ],
            ]
        );
    }
}
