<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Settings\Models\Setting;

final class FixDefaultReminderEmailSettings extends Migration
{
    public function up(): void
    {
        $settings = [
            'onboarding_email_enabled' => null,
            'reminder_email_enabled' => null,
            'onboarding_course' => optional(type_to_class('courses')::query()->where('status', 1)->first())->uuid ?? '',
        ];

        collect($settings)->each(
            fn ($value, $key) =>
            Setting::updateOrCreate(['group' => 'courses', 'key' => $key], ['value' => $value])
        );
    }
}
