<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

final class CreateCoursesRolesTable extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('inside_courses_roles')) {
            return;
        }

        Schema::create('inside_courses_roles', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedInteger('course_id');
            $table->unsignedInteger('role_id');
            $table->foreign('course_id')
                ->references('id')
                ->on('inside_courses')
                ->onDelete('cascade');
            $table->foreign('role_id')
                ->references('id')
                ->on('inside_roles')
                ->onDelete('cascade');
            $table->timestamps();
            $table->unique(['course_id', 'role_id']);
        });
    }
}
