<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema;
use Inside\Host\Bridge\BridgeContentType;

class addIntroductionToCoursesType extends Migration
{
    public function up(): void
    {
        if (Schema::hasField('courses', 'introduction')) {
            return;
        }

        $bridgeContentType = new BridgeContentType();

        $bridgeContentType->contentTypeCreateOrUpdateField(
            type: 'courses',
            fieldName: 'introduction',
            options: [
                'name' => 'introduction',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 5,
                'title' => [
                    'fr' => 'Introduction',
                    'en' => 'Introduction',
                    'es' => 'Introducción',
                    'de' => 'Einführung',
                    'pt' => 'Introdução',
                    'nl' => 'Inleiding',
                ],
                'description' => [],
                'widget' => [
                    'type' => BridgeContentType::LONGTEXT_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 5,
                ],
                'type' => BridgeContentType::TEXTAREA_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            weight: 5
        );
    }
}
