<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Bridge\BridgeContentType;

final class EnableListingCoursesCategoriesLangcode extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();
        $bridge->updateContentTypeOptions(
            type: 'listing_courses_categories',
            options: [
                'translatable' => true
            ]
        );

        if ((count(list_languages()) > 1)) {
            $bridge->changeFieldFormOptions(
                type: 'listing_courses_categories',
                fieldName: 'langcode',
                displayed: true,
                group: 'group_advanced_options'
            );
        }

        Artisan::call('models:rebuild');
    }
}
