<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Facades\Schema;
use Inside\Content\Models\Contents\Custom;
use Inside\Host\Bridge\BridgeContent;

final class CreateRelationBetweenCoursesCategoriesAndListingCoursesCategories extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            type: 'courses_categories',
            fieldName: 'listing_courses_categories',
            options: [
                'name' => 'listing_courses_categories',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => true,
                'searchable_filter' => true,
                'required' => false,
                'weight' => 2,
                'title' => [
                    'fr' => 'Listing de catégorie de formation',
                    'en' => 'Training category listing',
                    'es' => 'Lista de categorías de formación',
                    'de' => 'Kategorie-Übersicht für Schulungen',
                    'pt' => 'Lista de categorias de treinamento',
                    'nl' => 'Training categorie lijst',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 2,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['listing_courses_categories'],
                    'cardinality' => 1,
                ],
            ],
        );

        if (Schema::hasModel('custom')) {
            $bridge = new BridgeContent();

            Custom::query()
                ->where('custom_slug', 'courses')
                ->pluck('uuid')
                ->each(fn ($uuid) => $bridge->contentDelete('custom', $uuid));
        }

        Artisan::call('models:rebuild');
    }
}
