<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCoursesUsersStatisticsTable extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('inside_courses_users_statistics')) {
            return;
        }

        Schema::create('inside_courses_users_statistics', function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('course_id');
            $table->uuid('user_uuid');

            $table->boolean('viewed');
            $table->boolean('started');
            $table->boolean('finished');
            $table->float('ratio');

            $table->foreign('course_id')
                ->references('id')
                ->on('inside_courses')
                ->onDelete('cascade');

            $table->foreign('user_uuid')
                ->references('uuid')
                ->on('inside_users')
                ->onDelete('cascade');

            $table->unique(['course_id', 'user_uuid']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('inside_courses_users_statistics');
    }
}
