<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCoursesStatisticsTable extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('inside_courses_statistics')) {
            return;
        }

        Schema::create('inside_courses_statistics', function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('course_id');

            $table->integer('viewed');
            $table->integer('not_viewed');
            $table->integer('finished');
            $table->integer('not_finished');

            $table->float('average_ratio');

            $table->foreign('course_id')
                ->references('id')
                ->on('inside_courses')
                ->onDelete('cascade');

            $table->unique('course_id');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('inside_courses_statistics');
    }
}
