<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema;
use Inside\Content\Models\Contents\Custom;
use Inside\Host\Bridge\BridgeContent;

final class CreateCoursesCustomPages extends Migration
{
    public function createCustom(BridgeContent $bridge, array $data, string $langcode, ?Custom $original = null): ?Custom
    {
        $existing = Custom::query()
            ->where('redirection_page', $data['redirection_page'])
            ->where('langcode', $langcode)
            ->first();

        if ($existing instanceof Custom) {
            return $existing;
        }

        $data['langcode'] = $langcode;

        if ($original) {
            $data['uuid_host'] = $original->uuid_host;
        }

        $uuid = $bridge->contentInsert('custom', $data);

        return Custom::find($uuid);
    }

    public function up(): void
    {
        if (! Schema::hasModel('custom')) {
            return;
        }

        $bridge = new BridgeContent();

        $custom = [
            'title' => 'E-learning',
            'custom_slug' => 'courses',
            'redirection_page' => 'CoursesCategoriesListingPage',
        ];

        $locale = config('app.locale');

        $original = $this->createCustom($bridge, $custom, $locale);

        collect(list_languages())
            ->reject($locale)
            ->each(fn (string $langcode) => $this->createCustom($bridge, $custom, $langcode, $original));
    }
}
