<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCoursesStepsUsersValidationsTable extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('inside_courses_steps_users_validations')) {
            return;
        }

        Schema::create('inside_courses_steps_users_validations', function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('step_id');
            $table->uuid('user_uuid');
            $table->boolean('validated')->default(false);
            $table->timestamps();

            $table->foreign('step_id')
                ->references('id')
                ->on('inside_courses_steps')
                ->onDelete('cascade');

            $table->foreign('user_uuid')
                ->references('uuid')
                ->on('inside_users')
                ->onDelete('cascade');

            $table->unique(['step_id', 'user_uuid']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('inside_courses_steps_users_validations');
    }
}
