<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'courses_chapters',
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => false,
        'aliasable' => false,
        'permissible' => false,
        'categorizable' => false,
        'listing_type' => 'content',
        'title' => [
            'fr' => 'Chapitre de formation',
            'en' => 'Training chapter',
            'es' => 'Capítulo de formación',
            'de' => 'Schulungskapitel',
            'pt' => 'Capítulo de formação',
            'nl' => 'Trainingshoofdstuk',
        ],
    ],
    'fields' => [
        [
            'name' => 'courses',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 0,
            'title' => [
                'fr' => 'Formation',
                'en' => 'Training',
                'es' => 'Formación',
                'de' => 'Schulung',
                'pt' => 'Formação',
                'nl' => 'Training',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 0,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['courses'],
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'weight',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Ordre d\'affichage',
                'en' => 'Order of appearance',
                'es' => 'Orden de aparición',
                'de' => 'Reihenfolge des Erscheinens',
                'pt' => 'Ordem de aparência',
                'nl' => 'Volgorde van verschijning',
            ],
            'description' => [
                'fr' => 'Le nombre de plus bas remontera tout en haut',
                'en' => 'The lower number will go up at the top',
                'es' => 'El número más bajo subirá en la parte superior',
                'de' => 'Die niedrigere Nummer wird nach oben gehen',
                'pt' => 'O número menor subirá no topo',
                'nl' => 'Het lagere nummer komt bovenaan te staan',
            ],
            'widget' => [
                'type' => BridgeContentType::NUMBER_WIDGET,
                'settings' => [],
                'weight' => 1,
            ],
            'type' => BridgeContentType::INTEGER_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ],
    ],
];
