<?php

return [

    'debug' => env('DEBUG', false),

    'local' => [
        'home' => str(env('LOCAL_HOME', '~/Dev/Maecia'))->replace('~', '${HOME}'),
        'https' => [
            'cert' => env('LOCAL_CERT', '/home/inside/.inside/cert'),
            'key' => env('LOCAL_KEY', '/home/inside/.inside/key'),
        ],
    ],

    'servers' => [
        'dev' => [
            'host' => env('SERVER_HOST_DEV', 'dev.intranet-inside.com'),
            'port' => env('SERVER_PORT_DEV', '42'),
            'username' => env('SERVER_USER_NAME'),
        ],
        'pp' => [
            'host' => env('SERVER_HOST_PP', 'pp.intranet-inside.com'),
            'port' => env('SERVER_PORT_PP', '42'),
            'username' => env('SERVER_USER_NAME'),
        ],
    ],

    'databases' => [
        'dev-mysql' => [
            'host' => env('DATABASE_HOST_DEV_MYSQL', 'dev.intranet-inside.com'),
            'port' => env('DATABASE_PORT_DEV_MYSQL', '3306'),
            'username' => env('DATABASE_USERNAME_DEV_MYSQL', 'automysqlbackup'),
            'password' => env('DATABASE_PASSWORD_DEV_MYSQL'),
        ],
        'pp-mysql' => [
            'host' => env('DATABASE_HOST_PP_MYSQL', 'pp.intranet-inside.com'),
            'port' => env('DATABASE_PORT_PP_MYSQL', '3306'),
            'username' => env('DATABASE_USERNAME_PP_MYSQL', 'automysqlbackup'),
            'password' => env('DATABASE_PASSWORD_PP_MYSQL'),
        ],
        'dev-postgresql' => [
            'host' => env('DATABASE_HOST_DEV_POSTGRESQL', '51.159.56.153'),
            'port' => env('DATABASE_PORT_DEV_POSTGRESQL', '5432'),
            'username' => env('DATABASE_USERNAME_DEV_POSTGRESQL', 'autopostgresqlbackup'),
            'password' => env('DATABASE_PASSWORD_DEV_POSTGRESQL'),
        ],
        'pp-postgresql' => [
            'host' => env('DATABASE_HOST_PP_POSTGRESQL', '51.159.56.153'),
            'port' => env('DATABASE_PORT_PP_POSTGRESQL', '5432'),
            'username' => env('DATABASE_USERNAME_PP_POSTGRESQL', 'autopostgresqlbackup'),
            'password' => env('DATABASE_PASSWORD_PP_POSTGRESQL'),
        ],
    ],
];
