<?php

namespace App\Traits;

use Illuminate\Support\Facades\File;
use Illuminate\Support\Stringable;

trait DirectoryPathfinder
{
    public function isProjectExists(string $code): bool
    {
        return File::exists($this->createPath(config('inside.local.home'), $code));
    }

    public function findProjectDirectory(string $code): string
    {
        return $this->createPath(config('inside.local.home'), $code);
    }

    public function isProjectDirectory(): bool
    {
        return str(getcwd())
            ->after(config('inside.local.home'))
            ->after(DIRECTORY_SEPARATOR)
            ->before(DIRECTORY_SEPARATOR)
            ->match('/^[a-z0-9-]{4}$/')
            ->isNotEmpty();
    }

    public function appCode(): string
    {
        return basename($this->projectDirectory());
    }

    public function isPackageDirectory(): bool
    {
        return str(getcwd())
            ->after($this->createPath($this->projectDirectory(), 'vendor', 'maecia')->finish(DIRECTORY_SEPARATOR))
            ->whenContains(DIRECTORY_SEPARATOR, fn ($string) => $string->before(DIRECTORY_SEPARATOR))
            ->isNotEmpty();
    }

    public function appDirectory(): string
    {
        return '/var/www/html';
    }

    public function projectDirectory(): string
    {
        return str(getcwd())
            ->after(config('inside.local.home'))
            ->after(DIRECTORY_SEPARATOR)
            ->before(DIRECTORY_SEPARATOR)
            ->start(config('inside.local.home').DIRECTORY_SEPARATOR);
    }

    public function packageDirectory(): string
    {
        return str(getcwd())
            ->after($this->createPath('vendor', 'maecia')->finish(DIRECTORY_SEPARATOR))
            ->whenContains(DIRECTORY_SEPARATOR, fn ($string) => $string->before(DIRECTORY_SEPARATOR))
            ->start($this->createPath($this->projectDirectory(), 'vendor', 'maecia')->finish(DIRECTORY_SEPARATOR));
    }

    public function packageFromAppDirectory(): string
    {
        return str(getcwd())
            ->after($this->createPath('vendor', 'maecia')->finish(DIRECTORY_SEPARATOR))
            ->whenContains(DIRECTORY_SEPARATOR, fn ($string) => $string->before(DIRECTORY_SEPARATOR))
            ->start($this->createPath($this->appDirectory(), 'vendor', 'maecia')->finish(DIRECTORY_SEPARATOR));
    }

    public function createPath(string ...$directories): Stringable
    {
        return str(collect($directories)->join(DIRECTORY_SEPARATOR));
    }

    public function templateDirectory(): string
    {
        return $this->createPath('$HOME', '.inside', 'templates');
    }

    public function backTemplatePath(): string
    {
        return $this->createPath($this->templateDirectory(), 'back');
    }

    public function frontTemplatePath(): string
    {
        return $this->createPath($this->templateDirectory(), 'front');
    }
}
