<?php

namespace App\Services;

use Illuminate\Contracts\Process\ProcessResult;

final class TraefikService
{
    private const TRAEFIK_IMAGE = 'ghcr.io/pierreribault/intranet-inside-traefik:3.0';

    private const CONTAINER_NAME = 'inside-traefik';

    private const NETWORK_NAME = 'traefik_proxy';

    public static function start(): ProcessResult
    {
        return DockerService::run()
            ->image(self::TRAEFIK_IMAGE)
            ->port(80, 80)
            ->port(443, 443)
            ->volume('/var/run/docker.sock', '/var/run/docker.sock')
            ->volume(config('inside.local.https.cert'), '/certs/local-cert.pem')
            ->volume(config('inside.local.https.key'), '/certs/local-key.pem')
            ->label('traefik.enable=true')
            ->label('traefik.http.routers.dashboard.rule=Host(`traefik.docker.localhost`)')
            ->label('traefik.http.services.dashboard.loadbalancer.server.port=8080')
            ->label('traefik.http.routers.dashboard.tls=true')
            ->label('traefik.http.routers.dashboard.entrypoints=web,websecure')
            ->name(self::CONTAINER_NAME)
            ->networks(self::NETWORK_NAME)
            ->detach()
            ->execute();
    }

    public static function stop(): ProcessResult
    {
        return DockerService::rm()->force()->name(self::CONTAINER_NAME)->execute();
    }
}
