<?php

namespace App\Services;

use Illuminate\Contracts\Process\ProcessResult;
use Illuminate\Support\Facades\Process;
use Illuminate\Support\Traits\Conditionable;

final class TarService
{
    use Conditionable;

    private bool $zstd = false;

    private string $file = '';

    private string $directory = '';

    private function __construct()
    {
        //
    }

    public function zstd(): self
    {
        $this->zstd = true;

        return $this;
    }

    public function file(string $file): self
    {
        $this->file = $file;

        return $this;
    }

    public function directory(string $directory): self
    {
        $this->directory = $directory;

        return $this;
    }

    public function extract(): ProcessResult
    {
        return $this->execute('extract');
    }

    public function create(): ProcessResult
    {
        return $this->execute('create');
    }

    private function execute(string $action): ProcessResult
    {
        $command = collect(['tar']);

        if ($this->zstd) {
            $command->push('--zstd');
        }

        $command->push('-f');
        $command->push($this->file);

        match ($action) {
            'extract' => $command->push('-x'),
            default => $command->push('-c'),
        };

        $command->push($this->directory);

        return Process::forever()->run($command->join(' '));
    }

    public static function boot(): self
    {
        return new self();
    }
}
