<?php

namespace App\Services;

use Illuminate\Contracts\Process\ProcessResult;
use Illuminate\Support\Facades\Process;
use Illuminate\Support\Traits\Conditionable;

final class SedService
{
    use Conditionable;

    private string $input = '';

    private string $search = '';

    private string $replace = '';

    private string $flag = 'g';

    private function __construct()
    {
        //
    }

    public function input(string $input): self
    {
        $this->input = $input;

        return $this;
    }

    public function search(string $search): self
    {
        $this->search = $search;

        return $this;
    }

    public function replace(string $replace): self
    {
        $this->replace = $replace;

        return $this;
    }

    public function flag(string $flag): self
    {
        $this->flag = $flag;

        return $this;
    }

    public function execute(): ProcessResult
    {
        $command = "sed -i '' 's/{$this->search}/{$this->replace}/{$this->flag}' {$this->input}";

        return Process::forever()->tty()->run($command);
    }

    public static function boot(): self
    {
        return new self();
    }
}
