<?php

namespace App\Services;

use Illuminate\Contracts\Process\ProcessResult;
use Illuminate\Support\Facades\Process;
use Illuminate\Support\Traits\Conditionable;

final class RmService
{
    use Conditionable;

    private string $path = '';

    private bool $recursive = false;

    private bool $force = false;

    private function __construct()
    {
        //
    }

    public function path(string $path): self
    {
        $this->path = $path;

        return $this;
    }

    public function recursive(): self
    {
        $this->recursive = true;

        return $this;
    }

    public function force(): self
    {
        $this->force = true;

        return $this;
    }

    public function execute(): ProcessResult
    {
        $command = collect(['rm']);

        if ($this->recursive) {
            $command->push('-r');
        }

        if ($this->force) {
            $command->push('-f');
        }

        return Process::forever()->run($command->push($this->path)->join(' '));
    }

    public static function boot(): self
    {
        return new self();
    }
}
