<?php

namespace App\Services;

use Illuminate\Contracts\Process\ProcessResult;
use JetBrains\PhpStorm\NoReturn;

use function Termwind\render;

final class OutputService
{
    private bool $debug = false;

    private function __construct()
    {
        $this->debug = config('inside.debug');
    }

    public function debug(ProcessResult $result): void
    {
        if ($this->debug) {
            render(<<<HTML
                <div class="py-1 ml-2">
                    <div class="px-1 bg-orange-300 text-black">DEBUG IS ENABLED</div>
                    <ul class="px-1">
                        <li><b>Command</b>: <em class="text-blue">{$result->command()}</em></li>
                        <li><b>Exit Code</b>: <em class="text-yellow">{$result->exitCode()}</em></li>
                        <li><b>Output</b>: <em class="text-green">{$result->output()}</em></li>
                        <li><b>Error Output</b>: <em class="text-red">{$result->errorOutput()}</em></li>
                    </ul>
                </div>
            HTML
            );
        }
    }

    public function step(string $description, int $number, int $total): void
    {
        render(<<<HTML
            <div class="mt-2">
                <div class="px-1 text-blue-500 uppercase font-bold">STEP {$number}/{$total} - {$description}</div>
            </div>
        HTML);
    }

    public function success(string $title, string $description): void
    {
        render(<<<HTML
            <div class="pt-1 ml-2">
                <div class="px-1 bg-green-300 text-black">{$title}</div>
                <span class="ml-1">{$description}</span>
            </div>
        HTML);
    }

    public function warning(string $title, string $description): void
    {
        render(<<<HTML
            <div class="pt-1 ml-2">
                <div class="px-1 bg-orange-300 text-black">{$title}</div>
                <span class="ml-1">{$description}</span>
            </div>
        HTML);
    }

    public function error(string $title, string $description): void
    {
        render(<<<HTML
            <div class="pt-1 ml-2">
                <div class="px-1 bg-red-400 text-black">{$title}</div>
                <span class="ml-1">{$description}</span>
            </div>
        HTML);
    }

    #[NoReturn]
    public function kill(string $title, string $description): void
    {
        self::error($title, $description);
        exit(1);
    }

    public static function boot(): self
    {
        return new self();
    }
}
