<?php

namespace App\Services;

use Illuminate\Contracts\Process\ProcessResult;
use Illuminate\Support\Facades\Process;

final class NpmService
{
    private string $location = '';

    private bool $tty = false;

    private function __construct()
    {
        //
    }

    public function location(string $location): self
    {
        $this->location = $location.DIRECTORY_SEPARATOR.'front';

        return $this;
    }

    public function tty(): self
    {
        $this->tty = true;

        return $this;
    }

    public function install(): ProcessResult
    {
        return $this->execute('install');
    }

    public function update(): ProcessResult
    {
        return $this->execute('update');
    }

    public function build(): ProcessResult
    {
        return $this->execute('run build');
    }

    public function execute(string $action): ProcessResult
    {
        return Process::forever()
            ->when($this->location, fn ($process) => $process->path($this->location))
            ->when($this->tty, fn ($process) => $process->tty())
            ->run("npm {$action}");
    }

    public static function boot(): self
    {
        return new self();
    }
}
