<?php

namespace App\Services;

use Illuminate\Contracts\Process\ProcessResult;
use Illuminate\Support\Facades\Process;

final class MysqlService
{
    private string $remoteUser = '';

    private string $remoteHost = '';

    private string $host = '';

    private string $username = '';

    private string $password = '';

    private string $database = '';

    private string $path = '';

    private string $pathDirection = '';

    private function __construct()
    {
        //
    }

    public function remote(string $host, string $user): self
    {
        $this->remoteHost = $host;
        $this->remoteUser = $user;

        return $this;
    }

    public function host(string $host): self
    {
        $this->host = $host;

        return $this;
    }

    public function username(string $username): self
    {
        $this->username = $username;

        return $this;
    }

    public function password(string $password): self
    {
        $this->password = $password;

        return $this;
    }

    public function database(string $database): self
    {
        $this->database = $database;

        return $this;
    }

    public function directory(string $path): self
    {
        $this->path = $path;

        return $this;
    }

    public function import(): string
    {
        $this->pathDirection = '<';

        return $this->execute('mysql');
    }

    public function ping(): string
    {
        return $this->execute('mysqladmin ping');
    }

    public function dump(): ProcessResult
    {
        $this->pathDirection = '>';

        return Process::forever()->run($this->execute('mysqldump'));
    }

    private function execute(string $internalCommand): string
    {
        $command = collect();

        if ($this->remoteHost && $this->remoteUser) {
            $command->push('ssh');
            $command->push($this->remoteUser.'@'.$this->remoteHost);
        }

        $command->push($internalCommand);

        if ($this->host) {
            $command->push("-h{$this->host}");
        }

        if ($this->username) {
            $command->push("-u{$this->username}");
        }

        if ($this->password) {
            $command->push("-p{$this->password}");
        }

        if ($this->database) {
            $command->push($this->database);
        }

        if ($this->path) {
            $command->push($this->pathDirection);
            $command->push($this->path);
        }

        return $command->filter()->join(' ');
    }

    public static function boot(): self
    {
        return new self();
    }
}
