<?php

namespace App\Services\DockerModules;

use Illuminate\Contracts\Process\ProcessResult;
use Illuminate\Support\Facades\Process;

class DockerRm
{
    private bool $force = false;

    private string $name = '';

    public function __construct()
    {
        //
    }

    public function name(string $name): self
    {
        $this->name = $name;

        return $this;
    }

    public function force(): self
    {
        $this->force = true;

        return $this;
    }

    public function execute(): ProcessResult
    {
        $command = collect(['docker', 'rm']);

        if ($this->force) {
            $command->push('-f');
        }

        if ($this->name) {
            $command->push($this->name);
        }

        return Process::run($command->filter()->join(' '));
    }

    public static function boot(): self
    {
        return new static();
    }
}
