<?php

namespace App\Services;

use Illuminate\Contracts\Process\ProcessResult;
use Illuminate\Support\Facades\Process;
use Illuminate\Support\Traits\Conditionable;

final class CpService
{
    use Conditionable;

    private string $remoteUser = '';

    private string $remoteHost = '';

    private string $inputPath = '';

    private string $outputPath = '';

    private function __construct()
    {
        //
    }

    public function remote(string $host, string $user): self
    {
        $this->remoteHost = $host;
        $this->remoteUser = $user;

        return $this;
    }

    public function from(string $path): self
    {
        $this->inputPath = $path;

        return $this;
    }

    public function to(string $path): self
    {
        $this->outputPath = $path;

        return $this;
    }

    public function copy(): ProcessResult
    {
        return $this->execute();
    }

    private function execute(): ProcessResult
    {
        $command = collect();

        if ($this->remoteHost && $this->remoteUser) {
            $command->push("scp -r {$this->remoteUser}@{$this->remoteHost}:{$this->inputPath} {$this->outputPath}");
        } else {
            $command->push("cp -r {$this->inputPath} {$this->outputPath}");
        }

        return Process::forever()->tty()->run($command->filter()->join(' '));
    }

    public static function boot(): self
    {
        return new self();
    }
}
