<?php

namespace App\Services;

use Illuminate\Support\Traits\Conditionable;

final class ComposerService
{
    use Conditionable;

    private string $dependency = '';

    protected function __construct()
    {
        //
    }

    public function dependency(string $dependency): self
    {
        $this->dependency = $dependency;

        return $this;
    }

    public function execute(string $action): string
    {
        $command = collect(['COMPOSER_PROCESS_TIMEOUT=3000', 'COMPOSER_MEMORY_LIMIT=-1', 'composer', $action]);

        if ($this->dependency !== '') {
            $command->push('-d');
            $command->push($this->dependency);
            $command->push('--no-scripts');
        }

        return str($command->filter()->join(' '))->wrap('"')->start('su webuser -c ');
    }

    public static function boot(): self
    {
        return new self();
    }
}
