<?php

namespace App\Services\Commons;

use App\Services\CommandService;
use Illuminate\Contracts\Process\ProcessResult;
use Illuminate\Support\Traits\Conditionable;

final class TarService extends CommandService
{
    use Conditionable;

    private string $compress = '';

    private string $filename = '';

    public function zstd(): self
    {
        $this->compress = 'zstd';

        return $this;
    }

    public function gzip(): self
    {
        $this->compress = 'gzip';

        return $this;
    }

    public function bzip2(): self
    {
        $this->compress = 'bzip2';

        return $this;
    }

    public function xz(): self
    {
        $this->compress = 'xz';

        return $this;
    }

    public function lzma(): self
    {
        $this->compress = 'lzma';

        return $this;
    }

    public function filename(string $filename): self
    {
        $this->filename = $filename;

        return $this;
    }

    public function extract(): ProcessResult
    {
        $command = collect(['tar']);

        $command->push('--file');
        $command->push($this->filename);

        match ($this->compress) {
            'zstd' => $command->push('--zstd'),
            'gzip' => $command->push('-z'),
            'bzip2' => $command->push('-j'),
            'xz' => $command->push('-J'),
            'lzma' => $command->push('--lzma'),
        };

        $command->push('--extract');

        return $this->execute($command->join(' '));
    }

    public function create(string $path, false|string $root = false): ProcessResult
    {
        $command = collect(['tar']);

        $command->push('--file');
        $command->push($this->filename);


        $command->push('--create');
        $command->push($path);

        match ($this->compress) {
            'zstd' => $command->push('--zstd'),
            'gzip' => $command->push('-z'),
            'bzip2' => $command->push('-j'),
            'xz' => $command->push('-J'),
            'lzma' => $command->push('--lzma'),
        };

        if ($root) {
            $command->push('-C');
            $command->push($root);
        }

        return $this->execute($command->join(' '));
    }
}
