<?php

namespace App\Services\Commons;

use App\Services\CommandService;
use Illuminate\Contracts\Process\ProcessResult;
use Illuminate\Support\Traits\Conditionable;

final class SedService extends CommandService
{
    use Conditionable;

    private string $input = '';

    private string $search = '';

    private string $flag = 'g';

    public function input(string $input): self
    {
        $this->input = $input;

        return $this;
    }

    public function search(string $search): self
    {
        $this->search = $search;

        return $this;
    }

    public function replace(string $replace): ProcessResult
    {
        $command = "sed -i '' 's/{$this->search}/{$replace}/{$this->flag}' {$this->input}";

        return $this->execute($command);
    }

    public function flag(string $flag): self
    {
        $this->flag = $flag;

        return $this;
    }
}
