<?php

namespace App\Services\Commons;

use App\Services\CommandService;
use App\Services\Commons\Git\GitAddService;
use App\Services\Commons\Git\GitCheckoutService;
use App\Services\Commons\Git\GitCloneService;
use App\Services\Commons\Git\GitCommitService;
use App\Services\Commons\Git\GitInitService;
use App\Services\Commons\Git\GitPullService;
use App\Services\Commons\Git\GitPushService;
use App\Services\Commons\Git\GitRemoteService;
use Illuminate\Contracts\Process\ProcessResult;
use Illuminate\Support\Traits\Conditionable;

final class GitService extends CommandService
{
    use Conditionable;

    public function add(): GitAddService
    {
        return GitAddService::new();
    }

    public function checkout(): GitCheckoutService
    {
        return GitCheckoutService::new();
    }

    public function clone(): GitCloneService
    {
        return GitCloneService::new();
    }

    public function commit(): GitCommitService
    {
        return GitCommitService::new();
    }

    public function init(): GitInitService
    {
        return GitInitService::new();
    }

    public function pull(): GitPullService
    {
        return GitPullService::new();
    }

    public function push(): GitPushService
    {
        return GitPushService::new();
    }

    public function remote(): GitRemoteService
    {
        return GitRemoteService::new();
    }
}
